/*
 * Decompiled with CFR 0.152.
 */
package ome.io.nio;

import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ome.conditions.ApiUsageException;
import ome.io.nio.AbstractBuffer;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import ome.model.core.Pixels;
import ome.util.PixelData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RomioPixelBuffer
extends AbstractBuffer
implements PixelBuffer {
    private static Logger log = LoggerFactory.getLogger(RomioPixelBuffer.class);
    public static final int MAXIMUM_BUFFER_SIZE = 0x100000;
    private Pixels pixels;
    private RandomAccessFile file;
    private FileChannel channel;
    private Integer rowSize;
    private Integer colSize;
    private Long planeSize;
    private Long stackSize;
    private Long timepointSize;
    private Long totalSize;
    private final boolean permitModification;

    public RomioPixelBuffer(String path, Pixels pixels) {
        this(path, pixels, false);
    }

    public RomioPixelBuffer(String path, Pixels pixels, boolean permitModification) {
        super(path);
        if (pixels == null) {
            throw new NullPointerException("Expecting a not-null pixels element.");
        }
        this.pixels = pixels;
        this.permitModification = permitModification;
    }

    private void throwIfReadOnly() {
        if (!this.permitModification) {
            throw new ApiUsageException("Write-method not permitted.");
        }
    }

    public static Integer safeLongToInteger(Long v) {
        if (v > Integer.MAX_VALUE) {
            throw new ApiUsageException(String.format("Converting Long %d to Integer is an overflow.", v));
        }
        if (v < Integer.MIN_VALUE) {
            throw new ApiUsageException(String.format("Converting Long %d to Integer is an underflow.", v));
        }
        return v.intValue();
    }

    @Override
    public void checkBounds(Integer x, Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        if (x != null && (x > this.getSizeX() - 1 || x < 0)) {
            throw new DimensionsOutOfBoundsException("X '" + x + "' greater than sizeX '" + this.getSizeX() + "'.");
        }
        if (y != null && (y > this.getSizeY() - 1 || y < 0)) {
            throw new DimensionsOutOfBoundsException("Y '" + y + "' greater than sizeY '" + this.getSizeY() + "'.");
        }
        if (z != null && (z > this.getSizeZ() - 1 || z < 0)) {
            throw new DimensionsOutOfBoundsException("Z '" + z + "' greater than sizeZ '" + this.getSizeZ() + "'.");
        }
        if (c != null && (c > this.getSizeC() - 1 || c < 0)) {
            throw new DimensionsOutOfBoundsException("C '" + c + "' greater than sizeC '" + this.getSizeC() + "'.");
        }
        if (t != null && (t > this.getSizeT() - 1 || t < 0)) {
            throw new DimensionsOutOfBoundsException("T '" + t + "' greater than sizeT '" + this.getSizeT() + "'.");
        }
    }

    private FileChannel getFileChannel() throws FileNotFoundException {
        if (this.channel == null) {
            this.file = new RandomAccessFile(this.getPath(), "rw");
            this.channel = this.file.getChannel();
        }
        return this.channel;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                log.error("Error closing channel", (Throwable)e);
            }
            finally {
                this.channel = null;
            }
        }
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (Exception e) {
                log.error("Error closing file", (Throwable)e);
            }
            finally {
                this.file = null;
            }
        }
    }

    @Override
    public Long getPlaneSize() {
        if (this.planeSize == null) {
            this.planeSize = (long)this.getSizeX() * (long)this.getSizeY() * (long)this.getByteWidth();
        }
        return this.planeSize;
    }

    @Override
    public Integer getRowSize() {
        if (this.rowSize == null) {
            this.rowSize = this.getSizeX() * this.getByteWidth();
        }
        return this.rowSize;
    }

    @Override
    public Integer getColSize() {
        if (this.colSize == null) {
            this.colSize = this.getSizeY() * this.getByteWidth();
        }
        return this.colSize;
    }

    @Override
    public Long getStackSize() {
        if (this.stackSize == null) {
            this.stackSize = this.getPlaneSize() * (long)this.getSizeZ();
        }
        return this.stackSize;
    }

    @Override
    public Long getTimepointSize() {
        if (this.timepointSize == null) {
            this.timepointSize = this.getStackSize() * (long)this.getSizeC();
        }
        return this.timepointSize;
    }

    @Override
    public Long getTotalSize() {
        if (this.totalSize == null) {
            this.totalSize = this.getTimepointSize() * (long)this.getSizeT();
        }
        return this.totalSize;
    }

    @Override
    public Long getRowOffset(Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, y, z, c, t);
        Integer rowSize = this.getRowSize();
        Long timepointSize = this.getTimepointSize();
        Long stackSize = this.getStackSize();
        Long planeSize = this.getPlaneSize();
        return (long)rowSize.intValue() * (long)y.intValue() + timepointSize * (long)t.intValue() + stackSize * (long)c.intValue() + planeSize * (long)z.intValue();
    }

    @Override
    public Long getPlaneOffset(Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, null, z, c, t);
        Long timepointSize = this.getTimepointSize();
        Long stackSize = this.getStackSize();
        Long planeSize = this.getPlaneSize();
        return timepointSize * (long)t.intValue() + stackSize * (long)c.intValue() + planeSize * (long)z.intValue();
    }

    @Override
    public Long getStackOffset(Integer c, Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, null, null, c, t);
        Long timepointSize = this.getTimepointSize();
        Long stackSize = this.getStackSize();
        return timepointSize * (long)t.intValue() + stackSize * (long)c.intValue();
    }

    @Override
    public Long getTimepointOffset(Integer t) throws DimensionsOutOfBoundsException {
        this.checkBounds(null, null, null, null, t);
        Long timepointSize = this.getTimepointSize();
        return timepointSize * (long)t.intValue();
    }

    @Override
    public PixelData getRegion(Integer size, Long offset) throws IOException {
        FileChannel fileChannel = this.getFileChannel();
        MappedByteBuffer b = fileChannel.map(FileChannel.MapMode.READ_ONLY, offset, size.intValue());
        return new PixelData(this.pixels.getPixelsType().getValue(), (ByteBuffer)b);
    }

    @Override
    public byte[] getRegionDirect(Integer size, Long offset, byte[] buffer) throws IOException {
        if (buffer.length != size) {
            throw new ApiUsageException("Buffer size incorrect.");
        }
        PixelData pd = this.getRegion(size, offset);
        pd.getData().get(buffer);
        pd.dispose();
        return buffer;
    }

    @Override
    public PixelData getRow(Integer y, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        Long offset = this.getRowOffset(y, z, c, t);
        Integer size = this.getRowSize();
        return this.getRegion(size, offset);
    }

    @Override
    public PixelData getCol(Integer x, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        PixelData plane = this.getPlane(z, c, t);
        Integer sizeY = this.getSizeY();
        Integer sizeX = this.getSizeX();
        Integer colSize = this.getColSize();
        ByteBuffer buf = ByteBuffer.wrap(new byte[colSize.intValue()]);
        PixelData column = new PixelData(this.pixels.getPixelsType().getValue(), buf);
        for (int i = 0; i < sizeY; ++i) {
            int offset = i * sizeX + x;
            double value = plane.getPixelValue(offset);
            column.setPixelValue(i, value);
        }
        plane.dispose();
        return column;
    }

    @Override
    public byte[] getRowDirect(Integer y, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        if (buffer.length != this.getRowSize()) {
            throw new ApiUsageException("Buffer size incorrect.");
        }
        PixelData pd = this.getRow(y, z, c, t);
        pd.getData().get(buffer);
        pd.dispose();
        return buffer;
    }

    @Override
    public byte[] getColDirect(Integer x, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        PixelData plane = this.getPlane(z, c, t);
        Integer sizeY = this.getSizeY();
        Integer sizeX = this.getSizeX();
        ByteBuffer buf = ByteBuffer.wrap(buffer);
        PixelData column = new PixelData(this.pixels.getPixelsType().getValue(), buf);
        for (int i = 0; i < sizeY; ++i) {
            int offset = i * sizeX + x;
            double value = plane.getPixelValue(offset);
            column.setPixelValue(i, value);
        }
        plane.dispose();
        return buffer;
    }

    @Override
    public PixelData getHypercube(List<Integer> offset, List<Integer> size, List<Integer> step) throws IOException, DimensionsOutOfBoundsException {
        byte[] buffer = new byte[RomioPixelBuffer.safeLongToInteger(this.getHypercubeSize(offset, size, step)).intValue()];
        this.getHypercubeDirect(offset, size, step, buffer);
        return new PixelData(this.pixels.getPixelsType().getValue(), ByteBuffer.wrap(buffer));
    }

    @Override
    public byte[] getHypercubeDirect(List<Integer> offset, List<Integer> size, List<Integer> step, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        if ((long)buffer.length != this.getHypercubeSize(offset, size, step)) {
            throw new RuntimeException("Buffer size incorrect.");
        }
        this.getWholeHypercube(offset, size, step, buffer);
        return buffer;
    }

    @Override
    public byte[] getPlaneRegionDirect(Integer z, Integer c, Integer t, Integer count, Integer offset, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        PixelData pd = this.getPlane(z, c, t);
        ByteBuffer b = pd.getData();
        b.position(offset * this.getByteWidth());
        b.get(buffer, 0, count * this.getByteWidth());
        pd.dispose();
        return buffer;
    }

    @Override
    public PixelData getPlane(Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        log.info("Retrieving plane: " + z + "x" + c + "x" + t);
        Long offset = this.getPlaneOffset(z, c, t);
        Integer size = RomioPixelBuffer.safeLongToInteger(this.getPlaneSize());
        PixelData region = this.getRegion(size, offset);
        byte[] nullPlane = PixelsService.NULL_PLANE;
        for (int i = 0; i < 64; ++i) {
            if (region.getData().get(i) == nullPlane[i]) continue;
            return region;
        }
        region.dispose();
        return null;
    }

    @Override
    public PixelData getPlaneRegion(Integer x, Integer y, Integer width, Integer height, Integer z, Integer c, Integer t, Integer stride) throws IOException, DimensionsOutOfBoundsException {
        if (stride == null || stride < 0) {
            stride = 0;
        }
        this.checkBounds(x, y, z, c, t);
        this.checkBounds(x + width - 1, y + height - 1, null, null, null);
        PixelData plane = this.getPlane(z, c, t);
        PixelData region = null;
        if (stride == 0) {
            Integer size = width * height * this.getByteWidth();
            ByteBuffer buf = ByteBuffer.wrap(new byte[size.intValue()]);
            region = new PixelData(this.pixels.getPixelsType().getValue(), buf);
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int offset = (i + y) * this.getSizeX() + x + j;
                    region.setPixelValue(i * width + j, plane.getPixelValue(offset));
                }
            }
            plane.dispose();
            return region;
        }
        Integer i = stride;
        Integer j = stride = Integer.valueOf(stride + 1);
        int w = width / stride;
        Integer size = width * height * this.getByteWidth() / (stride * stride);
        ByteBuffer buf = ByteBuffer.wrap(new byte[size.intValue()]);
        region = new PixelData(this.pixels.getPixelsType().getValue(), buf);
        int k = 0;
        int l = 0;
        for (int i2 = 0; i2 < height; i2 += stride.intValue()) {
            l = 0;
            for (int j2 = 0; j2 < width; j2 += stride.intValue()) {
                int offset = (i2 + y) * this.getSizeX() + x + j2;
                region.setPixelValue(k * w + l, plane.getPixelValue(offset));
                ++l;
            }
            ++k;
        }
        plane.dispose();
        return region;
    }

    @Override
    public byte[] getPlaneDirect(Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        if ((long)buffer.length != this.getPlaneSize()) {
            throw new ApiUsageException("Buffer size incorrect.");
        }
        PixelData pd = this.getPlane(z, c, t);
        pd.getData().get(buffer);
        pd.dispose();
        return buffer;
    }

    @Override
    public PixelData getStack(Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        Long offset = this.getStackOffset(c, t);
        Integer size = RomioPixelBuffer.safeLongToInteger(this.getStackSize());
        return this.getRegion(size, offset);
    }

    @Override
    public byte[] getStackDirect(Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        if ((long)buffer.length != this.getStackSize()) {
            throw new ApiUsageException("Buffer size incorrect.");
        }
        PixelData pd = this.getStack(c, t);
        pd.getData().get(buffer);
        pd.dispose();
        return buffer;
    }

    @Override
    public PixelData getTimepoint(Integer t) throws IOException, DimensionsOutOfBoundsException {
        Long offset = this.getTimepointOffset(t);
        Integer size = RomioPixelBuffer.safeLongToInteger(this.getTimepointSize());
        return this.getRegion(size, offset);
    }

    @Override
    public byte[] getTimepointDirect(Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        if ((long)buffer.length != this.getTimepointSize()) {
            throw new ApiUsageException("Buffer size incorrect.");
        }
        PixelData pd = this.getTimepoint(t);
        pd.getData().get(buffer);
        pd.dispose();
        return buffer;
    }

    @Override
    public void setRegion(Integer size, Long offset, byte[] buffer) throws IOException {
        this.throwIfReadOnly();
        ByteBuffer buf = MappedByteBuffer.wrap(buffer);
        buf.limit(size);
        this.setRegion(size, offset, buf);
    }

    @Override
    public void setRegion(Integer size, Long offset, ByteBuffer buffer) throws IOException {
        this.throwIfReadOnly();
        FileChannel fileChannel = this.getFileChannel();
        fileChannel.write(buffer, offset);
    }

    @Override
    public void setRow(ByteBuffer buffer, Integer y, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        this.throwIfReadOnly();
        Long offset = this.getRowOffset(y, z, c, t);
        Integer size = this.getRowSize();
        this.setRegion(size, offset, buffer);
    }

    @Override
    public void setPlane(ByteBuffer buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        this.throwIfReadOnly();
        Long offset = this.getPlaneOffset(z, c, t);
        Integer size = RomioPixelBuffer.safeLongToInteger(this.getPlaneSize());
        if (buffer.limit() != size.intValue()) {
            if (buffer.limit() < size) {
                throw new BufferUnderflowException();
            }
            throw new BufferOverflowException();
        }
        this.setRegion(size, offset, buffer);
    }

    @Override
    public void setPlane(byte[] buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        this.throwIfReadOnly();
        this.setPlane(ByteBuffer.wrap(buffer), z, c, t);
    }

    @Override
    public void setStack(ByteBuffer buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        this.throwIfReadOnly();
        Long offset = this.getStackOffset(c, t);
        Integer size = RomioPixelBuffer.safeLongToInteger(this.getStackSize());
        if (buffer.limit() != size.intValue()) {
            if (buffer.limit() < size) {
                throw new BufferUnderflowException();
            }
            throw new BufferOverflowException();
        }
        this.setRegion(size, offset, buffer);
    }

    @Override
    public void setStack(byte[] buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        this.throwIfReadOnly();
        this.setStack(MappedByteBuffer.wrap(buffer), z, c, t);
    }

    @Override
    public void setTimepoint(ByteBuffer buffer, Integer t) throws IOException, DimensionsOutOfBoundsException {
        this.throwIfReadOnly();
        Long offset = this.getTimepointOffset(t);
        Integer size = RomioPixelBuffer.safeLongToInteger(this.getTimepointSize());
        if (buffer.limit() != size.intValue()) {
            if (buffer.limit() < size) {
                throw new BufferUnderflowException();
            }
            throw new BufferOverflowException();
        }
        this.setRegion(size, offset, buffer);
    }

    @Override
    public void setTimepoint(byte[] buffer, Integer t) throws IOException, DimensionsOutOfBoundsException {
        this.throwIfReadOnly();
        this.setTimepoint(MappedByteBuffer.wrap(buffer), t);
    }

    @Override
    public byte[] calculateMessageDigest() throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
        for (int t = 0; t < this.getSizeT(); ++t) {
            for (int c = 0; c < this.getSizeC(); ++c) {
                for (int z = 0; z < this.getSizeZ(); ++z) {
                    try {
                        PixelData pd = this.getPlane(z, c, t);
                        md.update(pd.getData());
                        pd.dispose();
                        continue;
                    }
                    catch (DimensionsOutOfBoundsException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return md.digest();
    }

    @Override
    public int getByteWidth() {
        return PixelData.getBitDepth((String)this.pixels.getPixelsType().getValue()) / 8;
    }

    @Override
    public boolean isSigned() {
        PixelData d = new PixelData(this.pixels.getPixelsType().getValue(), null);
        return d.isSigned();
    }

    @Override
    public boolean isFloat() {
        PixelData d = new PixelData(this.pixels.getPixelsType().getValue(), null);
        return d.isFloat();
    }

    @Override
    public int getSizeC() {
        return this.pixels.getSizeC();
    }

    @Override
    public int getSizeT() {
        return this.pixels.getSizeT();
    }

    @Override
    public int getSizeX() {
        return this.pixels.getSizeX();
    }

    @Override
    public int getSizeY() {
        return this.pixels.getSizeY();
    }

    @Override
    public int getSizeZ() {
        return this.pixels.getSizeZ();
    }

    @Override
    public long getId() {
        return this.pixels.getId();
    }

    public String getSha1() {
        return this.pixels.getSha1();
    }

    @Override
    public PixelData getTile(Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h) throws IOException {
        return this.getPlaneRegion(x, y, w, h, z, c, t, 0);
    }

    @Override
    public byte[] getTileDirect(Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h, byte[] buffer) throws IOException {
        List<Integer> offset = Arrays.asList(x, y, z, c, t);
        List<Integer> size = Arrays.asList(w, h, 1, 1, 1);
        List<Integer> step = Arrays.asList(1, 1, 1, 1, 1);
        return this.getHypercubeDirect(offset, size, step, buffer);
    }

    @Override
    public void setTile(byte[] buffer, Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h) throws IOException, BufferOverflowException {
        if (x != 0) {
            throw new UnsupportedOperationException("ROMIO pixel buffer only supports 0 offseted tile writes.");
        }
        if (w.intValue() != this.getSizeX()) {
            throw new UnsupportedOperationException("ROMIO pixel buffer only supports full row writes.");
        }
        try {
            long offset = this.getPlaneOffset(z, c, t);
            this.setRegion((Integer)buffer.length, (Long)(offset += (long)(this.getByteWidth() * this.getSizeX() * y)), buffer);
        }
        catch (DimensionsOutOfBoundsException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getResolutionLevel() {
        return 0;
    }

    @Override
    public int getResolutionLevels() {
        return 1;
    }

    @Override
    public List<List<Integer>> getResolutionDescriptions() {
        List<Integer> sizes = Arrays.asList(this.getSizeX(), this.getSizeY());
        ArrayList<List<Integer>> rv = new ArrayList<List<Integer>>();
        rv.add(sizes);
        return rv;
    }

    @Override
    public Dimension getTileSize() {
        int width = this.getSizeX();
        int height = Math.min(this.getSizeY(), 0x100000 / this.getByteWidth() / this.getSizeX());
        return new Dimension(width, height);
    }

    @Override
    public void setResolutionLevel(int resolutionLevel) {
        throw new UnsupportedOperationException("Cannot set resolution levels on a ROMIO pixel buffer.");
    }

    @Override
    public Long getHypercubeSize(List<Integer> offset, List<Integer> size, List<Integer> step) throws DimensionsOutOfBoundsException {
        this.checkCubeBounds(offset, size, step);
        int tStripes = (size.get(4) + step.get(4) - 1) / step.get(4);
        int cStripes = (size.get(3) + step.get(3) - 1) / step.get(3);
        int zStripes = (size.get(2) + step.get(2) - 1) / step.get(2);
        int yStripes = (size.get(1) + step.get(1) - 1) / step.get(1);
        int xStripes = (size.get(0) + step.get(0) - 1) / step.get(0);
        long tileRowSize = (long)this.getByteWidth() * (long)xStripes;
        long cubeSize = tileRowSize * (long)yStripes * (long)zStripes * (long)cStripes * (long)tStripes;
        return cubeSize;
    }

    private byte[] getWholeHypercube(List<Integer> offset, List<Integer> size, List<Integer> step, byte[] cube) throws IOException {
        int cubeOffset = 0;
        int xStripes = (size.get(0) + step.get(0) - 1) / step.get(0);
        int pixelSize = this.getByteWidth();
        int tileRowSize = pixelSize * xStripes;
        byte[] plane = new byte[RomioPixelBuffer.safeLongToInteger(this.getPlaneSize()).intValue()];
        for (int t = offset.get(4).intValue(); t < size.get(4) + offset.get(4); t += step.get(4).intValue()) {
            for (int c = offset.get(3).intValue(); c < size.get(3) + offset.get(3); c += step.get(3).intValue()) {
                for (int z = offset.get(2).intValue(); z < size.get(2) + offset.get(2); z += step.get(2).intValue()) {
                    this.getPlaneDirect(z, c, t, plane);
                    int rowOffset = offset.get(1) * this.getRowSize();
                    if (step.get(0) == 1) {
                        int byteOffset = rowOffset + offset.get(0) * pixelSize;
                        for (int y = offset.get(1).intValue(); y < size.get(1) + offset.get(1); y += step.get(1).intValue()) {
                            System.arraycopy(plane, byteOffset, cube, cubeOffset, tileRowSize);
                            cubeOffset += tileRowSize;
                            byteOffset += this.getRowSize() * step.get(1);
                        }
                        continue;
                    }
                    for (int y = offset.get(1).intValue(); y < size.get(1) + offset.get(1); y += step.get(1).intValue()) {
                        int byteOffset = offset.get(0) * pixelSize;
                        for (int x = offset.get(0).intValue(); x < size.get(0) + offset.get(0); x += step.get(0).intValue()) {
                            System.arraycopy(plane, rowOffset + byteOffset, cube, cubeOffset, pixelSize);
                            cubeOffset += pixelSize;
                            byteOffset += step.get(0) * pixelSize;
                        }
                        rowOffset += this.getRowSize() * step.get(1);
                    }
                }
            }
        }
        return cube;
    }

    private void checkCubeBounds(List<Integer> offset, List<Integer> size, List<Integer> step) throws DimensionsOutOfBoundsException {
        if (offset.size() != 5 || size.size() != 5 || step.size() != 5) {
            throw new DimensionsOutOfBoundsException("Invalid List length: each list must contain 5 elements XYZCT");
        }
        this.checkBounds(offset.get(0), offset.get(1), offset.get(2), offset.get(3), offset.get(4));
        this.checkBounds(offset.get(0) + size.get(0) - 1, offset.get(1) + size.get(1) - 1, offset.get(2) + size.get(2) - 1, offset.get(3) + size.get(3) - 1, offset.get(4) + size.get(4) - 1);
        if (step.get(0) < 1 || step.get(1) < 1 || step.get(2) < 1 || step.get(3) < 1 || step.get(4) < 1) {
            throw new DimensionsOutOfBoundsException("Invalid step size: steps sizes must be 1 or greater");
        }
    }
}

