/*
 * Decompiled with CFR 0.152.
 */
package ome.services.sessions;

import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import ome.api.IQuery;
import ome.model.meta.Experimenter;
import ome.model.meta.Node;
import ome.model.meta.Session;
import ome.security.NodeProvider;
import ome.services.sessions.SessionProvider;
import ome.services.util.Executor;
import ome.services.util.ReadOnlyStatus;
import ome.system.Roles;
import ome.system.ServiceFactory;
import ome.util.SqlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class SessionProviderInMemory
implements SessionProvider,
ReadOnlyStatus.IsAware {
    private static final Logger log = LoggerFactory.getLogger(SessionProviderInMemory.class);
    private final Roles roles;
    private final NodeProvider nodeProvider;
    private final Executor executor;
    private final AtomicLong currentSessionId = new AtomicLong(-1L);
    private final Map<String, Session> openSessions = new ConcurrentHashMap<String, Session>();
    private final Map<String, Session> closedSessions = CacheBuilder.newBuilder().maximumSize(512L).build().asMap();

    public SessionProviderInMemory(Roles roles, NodeProvider nodeProvider, Executor executor) {
        this.roles = roles;
        this.nodeProvider = nodeProvider;
        this.executor = executor;
    }

    @Override
    public Session executeUpdate(ServiceFactory sf, Session session, String uuid, long userId, Long sudoerId) {
        IQuery iQuery = sf.getQueryService();
        Node node = this.nodeProvider.getManagerByUuid(uuid, sf);
        if (node == null) {
            node = new Node(Long.valueOf(0L), false);
        }
        if (session.getId() == null) {
            session.setId(Long.valueOf(this.executeNextSessionId()));
        }
        session.setNode(node);
        session.setOwner((Experimenter)iQuery.get(Experimenter.class, userId));
        if (sudoerId == null) {
            session.setSudoer(null);
        } else {
            session.setSudoer((Experimenter)iQuery.get(Experimenter.class, sudoerId.longValue()));
        }
        if (session.getClosed() == null) {
            this.openSessions.put(session.getUuid(), session);
            this.closedSessions.remove(session.getUuid());
        } else {
            this.closedSessions.put(session.getUuid(), session);
            this.openSessions.remove(session.getUuid());
        }
        log.debug("Registered Session:{} ({})", (Object)session.getId(), (Object)session.getUuid());
        session.setUserIP(null);
        return session;
    }

    @Override
    public long executeNextSessionId() {
        return this.currentSessionId.getAndDecrement();
    }

    @Override
    public Session executeInternalSession(final String uuid, Session session) {
        Node node = (Node)this.executor.executeSql(new Executor.SimpleSqlWork(this, "executeInternalSession", new Object[0]){

            @Override
            @Transactional(readOnly=true)
            public Object doWork(SqlAction sql) {
                Long nodeId = SessionProviderInMemory.this.nodeProvider.getManagerIdByUuid(uuid, sql);
                return nodeId == null ? null : new Node(nodeId, false);
            }
        });
        session.setId(Long.valueOf(this.executeNextSessionId()));
        log.debug("Created session: {}", (Object)session);
        log.debug("Setting node: {}", (Object)node);
        session.setNode(node);
        session.setOwner(new Experimenter(Long.valueOf(this.roles.getRootId()), false));
        this.openSessions.put(session.getUuid(), session);
        return session;
    }

    @Override
    public void executeCloseSession(String uuid) {
        Session session = this.openSessions.get(uuid);
        if (session == null) {
            if (this.closedSessions.containsKey(uuid)) {
                log.debug("attempt to close session {} but is already closed", (Object)uuid);
            } else {
                log.warn("attempt to close session {} but is no longer cached", (Object)uuid);
            }
        } else {
            session.setClosed(new Timestamp(System.currentTimeMillis()));
            this.closedSessions.put(session.getUuid(), session);
            this.openSessions.remove(session.getUuid());
            log.debug("closed session {}", (Object)uuid);
        }
    }

    @Override
    public Session findSessionById(long id, org.hibernate.Session session) {
        return this.findSessionById(id, (ServiceFactory)null);
    }

    @Override
    public Session findSessionById(long id, ServiceFactory sf) {
        TreeSet<Long> tries = new TreeSet<Long>();
        Stream<Session> sessionStream = Stream.concat(this.openSessions.values().stream(), this.closedSessions.values().stream());
        for (Session session : sessionStream::iterator) {
            if (session.getId().equals(id)) {
                return session;
            }
            tries.add(session.getId());
        }
        log.info("Requested unknown session ID {}. Found {} other sessions.", (Object)id, (Object)tries.size());
        log.debug("Found sessions: {}", tries);
        return null;
    }

    @Override
    public Long findSessionIdByUuid(String uuid, ServiceFactory sf) {
        return this.findSessionIdByUuid(uuid);
    }

    @Override
    public Long findSessionIdByUuid(String uuid) {
        for (Map sessions : ImmutableList.of(this.openSessions, this.closedSessions)) {
            Session session = (Session)sessions.get(uuid);
            if (session == null) continue;
            return session.getId();
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ReadOnlyStatus readOnly) {
        return false;
    }
}

