/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.Projection;
import org.locationtech.proj4j.util.ProjectionMath;

public class NellProjection
extends Projection {
    private static final int MAX_ITER = 10;
    private static final double LOOP_TOL = 1.0E-7;

    @Override
    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double k = 2.0 * Math.sin(lpphi);
        double V = lpphi * lpphi;
        out.y *= 1.00371 + V * (-0.0935382 + V * -0.011412);
        for (int i = 10; i > 0; --i) {
            V = (lpphi + Math.sin(lpphi) - k) / (1.0 + Math.cos(lpphi));
            out.y -= V;
            if (Math.abs(V) < 1.0E-7) break;
        }
        out.x = 0.5 * lplam * (1.0 + Math.cos(lpphi));
        out.y = lpphi;
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        out.x = 2.0 * xyx / (1.0 + Math.cos(xyy));
        out.y = ProjectionMath.asin(0.5 * (xyy + Math.sin(xyy)));
        return out;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Nell";
    }
}

