/*
 * Decompiled with CFR 0.152.
 */
package ome.services.blitz.impl;

import Ice.Current;
import Ice.Identity;
import java.util.Map;
import java.util.UUID;
import ome.services.blitz.impl.AbstractAmdServant;
import ome.services.blitz.impl.ServiceFactoryI;
import ome.services.procs.scripts.ScriptProcess;
import omero.ApiUsageException;
import omero.RInt;
import omero.RType;
import omero.ServerError;
import omero.api.JobHandlePrx;
import omero.grid.InteractiveProcessorPrx;
import omero.grid.ProcessCallbackI;
import omero.grid.ProcessCallbackPrx;
import omero.grid.ProcessPrx;
import omero.grid.ScriptProcessPrx;
import omero.grid.ScriptProcessPrxHelper;
import omero.grid._InteractiveProcessorOperations;
import omero.grid._ScriptProcessOperations;
import omero.grid._ScriptProcessTie;
import omero.model.ScriptJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptProcessI
extends AbstractAmdServant
implements _ScriptProcessOperations {
    private static Logger log = LoggerFactory.getLogger(ScriptProcess.class);
    private final InteractiveProcessorPrx processorPrx;
    private final _InteractiveProcessorOperations processor;
    private final ProcessPrx process;
    private final ProcessCallbackI cb;
    private final ServiceFactoryI sf;
    private final ScriptProcessPrx self;
    private final Identity id;
    private final long jobId;

    public ScriptProcessI(ServiceFactoryI sf, Current current, InteractiveProcessorPrx processorPrx, _InteractiveProcessorOperations processor, ProcessPrx process) throws ServerError {
        super(null, null);
        this.jobId = processor.getJob(current).getId().getValue();
        this.processorPrx = processorPrx;
        this.processor = processor;
        this.process = process;
        this.sf = sf;
        this.cb = new ProcessCallbackI(sf.getAdapter(), "ProcessCallback", process);
        this.id = new Identity(UUID.randomUUID().toString(), "ProcessCallback");
        this.self = ScriptProcessPrxHelper.uncheckedCast(sf.registerServant(this.id, new _ScriptProcessTie(this)));
        sf.allow(this.self);
    }

    public ScriptProcessPrx getProxy() {
        return this.self;
    }

    @Override
    public void close(boolean detach, Current __current) throws ServerError {
        this.processor.setDetach(detach, __current);
        this.processor.stop(__current);
        this.sf.unregisterServant(this.processorPrx.ice_getIdentity());
        this.sf.unregisterServant(this.self.ice_getIdentity());
        this.cb.close();
    }

    @Override
    public ScriptJob getJob(Current __current) throws ServerError {
        return (ScriptJob)this.processor.getJob(__current);
    }

    @Override
    public Map<String, RType> getResults(int waitSecs, Current __current) throws ServerError {
        if (waitSecs > 5 || 0 > waitSecs) {
            throw new ApiUsageException(null, null, "Refusing to wait more than 5 seconds: " + waitSecs);
        }
        try {
            this.cb.block(waitSecs * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.processor.getResults(this.process, __current).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setMessage(String message, Current __current) throws ServerError {
        try (JobHandlePrx jh = this.sf.createJobHandle(null);){
            jh.attach(this.jobId);
            String string = jh.setMessage(message);
            return string;
        }
    }

    @Override
    public int _wait(Current __current) throws ServerError {
        return this.process._wait();
    }

    @Override
    public boolean cancel(Current __current) throws ServerError {
        return this.process.cancel();
    }

    @Override
    public boolean kill(Current __current) {
        return this.process.kill();
    }

    @Override
    public RInt poll(Current __current) throws ServerError {
        return this.process.poll();
    }

    @Override
    public void registerCallback(ProcessCallbackPrx cb, Current __current) throws ServerError {
        this.process.registerCallback(cb);
    }

    @Override
    public void shutdown(Current __current) {
        this.process.shutdown();
    }

    @Override
    public void unregisterCallback(ProcessCallbackPrx cb, Current __current) throws ServerError {
        this.process.unregisterCallback(cb);
    }
}

