/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v2.codec.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.ArrayMetadata;
import dev.zarr.zarrjava.core.codec.BytesBytesCodec;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v2.codec.Codec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class ZlibCodec
extends BytesBytesCodec
implements Codec {
    public final String id = "zlib";
    public final int level;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public ZlibCodec(@JsonProperty(value="level", defaultValue="1") int level) throws ZarrException {
        if (level < 0 || level > 9) {
            throw new ZarrException("'level' needs to be between 0 and 9.");
        }
        this.level = level;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer decode(ByteBuffer chunkBytes) throws ZarrException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ByteBuffer byteBuffer;
            try (InflaterInputStream inputStream = new InflaterInputStream(new ByteArrayInputStream(Utils.toArray(chunkBytes)));){
                Utils.copyStream(inputStream, outputStream);
                inputStream.close();
                byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
            }
            return byteBuffer;
        }
        catch (IOException ex) {
            throw new ZarrException("Error in decoding gzip.", ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteBuffer encode(ByteBuffer chunkBytes) throws ZarrException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ByteBuffer byteBuffer;
            try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)outputStream, new Deflater(this.level));){
                dos.write(Utils.toArray(chunkBytes));
                dos.close();
                byteBuffer = ByteBuffer.wrap(outputStream.toByteArray());
            }
            return byteBuffer;
        }
        catch (IOException ex) {
            throw new ZarrException("Error in encoding zlib.", ex);
        }
    }

    @Override
    public Codec evolveFromCoreArrayMetadata(ArrayMetadata.CoreArrayMetadata arrayMetadata) {
        return this;
    }
}

