/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.DataType;
import dev.zarr.zarrjava.core.chunkkeyencoding.ChunkKeyEncoding;
import dev.zarr.zarrjava.utils.MultiArrayUtils;
import dev.zarr.zarrjava.utils.Utils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Nonnull;
import ucar.ma2.Array;

public abstract class ArrayMetadata {
    public final long[] shape;
    @JsonProperty(value="fill_value")
    public final Object fillValue;
    @JsonIgnore
    public final Object parsedFillValue;

    public ArrayMetadata(long[] shape, Object fillValue, DataType dataType) throws ZarrException {
        this.shape = shape;
        this.fillValue = fillValue;
        this.parsedFillValue = ArrayMetadata.parseFillValue(fillValue, dataType);
    }

    public int ndim() {
        return this.shape.length;
    }

    public abstract int[] chunkShape();

    public abstract DataType dataType();

    public abstract Array allocateFillValueChunk();

    public abstract ChunkKeyEncoding chunkKeyEncoding();

    public abstract Object parsedFillValue();

    public static Object parseFillValue(Object fillValue, @Nonnull DataType dataType) throws ZarrException {
        boolean dataTypeIsDouble;
        if (fillValue == null) {
            return null;
        }
        boolean dataTypeIsBool = dataType == dev.zarr.zarrjava.v3.DataType.BOOL || dataType == dev.zarr.zarrjava.v2.DataType.BOOL;
        boolean dataTypeIsByte = dataType == dev.zarr.zarrjava.v3.DataType.INT8 || dataType == dev.zarr.zarrjava.v2.DataType.INT8 || dataType == dev.zarr.zarrjava.v3.DataType.UINT8 || dataType == dev.zarr.zarrjava.v2.DataType.UINT8;
        boolean dataTypeIsShort = dataType == dev.zarr.zarrjava.v3.DataType.INT16 || dataType == dev.zarr.zarrjava.v2.DataType.INT16 || dataType == dev.zarr.zarrjava.v3.DataType.UINT16 || dataType == dev.zarr.zarrjava.v2.DataType.UINT16;
        boolean dataTypeIsInt = dataType == dev.zarr.zarrjava.v3.DataType.INT32 || dataType == dev.zarr.zarrjava.v2.DataType.INT32 || dataType == dev.zarr.zarrjava.v3.DataType.UINT32 || dataType == dev.zarr.zarrjava.v2.DataType.UINT32;
        boolean dataTypeIsLong = dataType == dev.zarr.zarrjava.v3.DataType.INT64 || dataType == dev.zarr.zarrjava.v2.DataType.INT64 || dataType == dev.zarr.zarrjava.v3.DataType.UINT64 || dataType == dev.zarr.zarrjava.v2.DataType.UINT64;
        boolean dataTypeIsFloat = dataType == dev.zarr.zarrjava.v3.DataType.FLOAT32 || dataType == dev.zarr.zarrjava.v2.DataType.FLOAT32;
        boolean bl = dataTypeIsDouble = dataType == dev.zarr.zarrjava.v3.DataType.FLOAT64 || dataType == dev.zarr.zarrjava.v2.DataType.FLOAT64;
        if (fillValue instanceof Boolean) {
            Boolean fillValueBool = (Boolean)fillValue;
            if (dataTypeIsBool) {
                return fillValueBool;
            }
        }
        if (fillValue instanceof Number) {
            Number fillValueNumber = (Number)fillValue;
            if (dataTypeIsBool) {
                return fillValueNumber.byteValue() != 0;
            }
            if (dataTypeIsByte) {
                return fillValueNumber.byteValue();
            }
            if (dataTypeIsShort) {
                return fillValueNumber.shortValue();
            }
            if (dataTypeIsInt) {
                return fillValueNumber.intValue();
            }
            if (dataTypeIsLong) {
                return fillValueNumber.longValue();
            }
            if (dataTypeIsFloat) {
                return Float.valueOf(fillValueNumber.floatValue());
            }
            if (dataTypeIsDouble) {
                return fillValueNumber.doubleValue();
            }
        } else if (fillValue instanceof String) {
            String fillValueString = (String)fillValue;
            if (fillValueString.equals("NaN")) {
                if (dataTypeIsFloat) {
                    return Float.valueOf(Float.NaN);
                }
                if (dataTypeIsDouble) {
                    return Double.NaN;
                }
                throw new ZarrException("Invalid fill value '" + fillValueString + "' for data type '" + dataType + "'.");
            }
            if (fillValueString.equals("+Infinity")) {
                if (dataTypeIsFloat) {
                    return Float.valueOf(Float.POSITIVE_INFINITY);
                }
                if (dataTypeIsDouble) {
                    return Double.POSITIVE_INFINITY;
                }
                throw new ZarrException("Invalid fill value '" + fillValueString + "' for data type '" + dataType + "'.");
            }
            if (fillValueString.equals("-Infinity")) {
                if (dataTypeIsFloat) {
                    return Float.valueOf(Float.NEGATIVE_INFINITY);
                }
                if (dataTypeIsDouble) {
                    return Double.NEGATIVE_INFINITY;
                }
                throw new ZarrException("Invalid fill value '" + fillValueString + "' for data type '" + dataType + "'.");
            }
            if (fillValueString.startsWith("0b") || fillValueString.startsWith("0x")) {
                ByteBuffer buf = null;
                if (fillValueString.startsWith("0b")) {
                    buf = Utils.makeByteBuffer(dataType.getByteCount(), b -> {
                        for (int i = 0; i < dataType.getByteCount(); ++i) {
                            b.put((byte)Integer.parseInt(fillValueString.substring(2 + i * 8, 2 + (i + 1) * 8), 2));
                        }
                        return b;
                    });
                } else if (fillValueString.startsWith("0x")) {
                    buf = Utils.makeByteBuffer(dataType.getByteCount(), b -> {
                        for (int i = 0; i < dataType.getByteCount(); ++i) {
                            b.put((byte)Integer.parseInt(fillValueString.substring(2 + i * 2, 2 + (i + 1) * 2), 16));
                        }
                        return b;
                    });
                }
                if (buf != null) {
                    if (dataTypeIsBool) {
                        return buf.get() != 0;
                    }
                    if (dataTypeIsByte) {
                        return buf.get();
                    }
                    if (dataTypeIsShort) {
                        return buf.getShort();
                    }
                    if (dataTypeIsInt) {
                        return buf.getInt();
                    }
                    if (dataTypeIsLong) {
                        return buf.getLong();
                    }
                    if (dataTypeIsFloat) {
                        return Float.valueOf(buf.getFloat());
                    }
                    if (dataTypeIsDouble) {
                        return buf.getDouble();
                    }
                }
            }
        }
        throw new ZarrException("Invalid fill value '" + fillValue + "'.");
    }

    public static final class CoreArrayMetadata {
        public final long[] shape;
        public final int[] chunkShape;
        public final DataType dataType;
        public final Object parsedFillValue;

        public CoreArrayMetadata(long[] shape, int[] chunkShape, DataType dataType, Object parsedFillValue) {
            this.shape = shape;
            this.chunkShape = chunkShape;
            this.dataType = dataType;
            this.parsedFillValue = parsedFillValue;
        }

        public int ndim() {
            return this.shape.length;
        }

        public int chunkSize() {
            return Arrays.stream(this.chunkShape).reduce(1, (acc, a) -> acc * a);
        }

        public int chunkByteLength() {
            return this.dataType.getByteCount() * this.chunkSize();
        }

        public Array allocateFillValueChunk() {
            Array outputArray = Array.factory((ucar.ma2.DataType)this.dataType.getMA2DataType(), (int[])this.chunkShape);
            MultiArrayUtils.fill(outputArray, this.parsedFillValue);
            return outputArray;
        }
    }
}

