/*
 * Decompiled with CFR 0.152.
 */
package com.glencoesoftware.omero.zarr;

import com.bc.zarr.DataType;
import com.bc.zarr.ZarrArray;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.IntStream;
import loci.formats.FormatTools;
import ome.io.nio.DimensionsOutOfBoundsException;
import ome.io.nio.PixelBuffer;
import ome.io.nio.RomioPixelBuffer;
import ome.model.core.Pixels;
import ome.util.PixelData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;

public class ZarrPixelBuffer
implements PixelBuffer {
    private static final Logger log = LoggerFactory.getLogger(ZarrPixelBuffer.class);
    private final Pixels pixels;
    private final Path root;
    private int resolutionLevel;
    private final int resolutionLevels;
    private final Integer maxPlaneWidth;
    private final Integer maxPlaneHeight;
    private final Map<String, Object> rootGroupAttributes;
    private ZarrArray array;
    private Map<Integer, Integer> zIndexMap;
    private final AsyncLoadingCache<List<Integer>, byte[]> tileCache;
    private final boolean isRemote;
    private final AsyncLoadingCache<Path, Map<String, Object>> zarrMetadataCache;
    private final AsyncLoadingCache<Path, ZarrArray> zarrArrayCache;
    private Map<Axis, Integer> axesOrder;

    public ZarrPixelBuffer(Pixels pixels, Path root, Integer maxPlaneWidth, Integer maxPlaneHeight, AsyncLoadingCache<Path, Map<String, Object>> zarrMetadataCache, AsyncLoadingCache<Path, ZarrArray> zarrArrayCache) throws IOException {
        log.info("Creating ZarrPixelBuffer");
        this.pixels = pixels;
        this.root = root;
        this.zarrMetadataCache = zarrMetadataCache;
        this.zarrArrayCache = zarrArrayCache;
        this.isRemote = root.toString().startsWith("s3://");
        try {
            this.rootGroupAttributes = (Map)this.zarrMetadataCache.get((Object)this.root).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
        if (!this.rootGroupAttributes.containsKey("multiscales")) {
            throw new IllegalArgumentException("Missing multiscales metadata!");
        }
        this.axesOrder = this.getAxesOrder();
        this.resolutionLevels = this.getResolutionLevels();
        this.setResolutionLevel(this.resolutionLevels - 1);
        if (this.resolutionLevel < 0) {
            throw new IllegalArgumentException("This Zarr file has no pixel data");
        }
        this.maxPlaneWidth = maxPlaneWidth;
        this.maxPlaneHeight = maxPlaneHeight;
        this.tileCache = Caffeine.newBuilder().maximumSize((long)this.getSizeC()).buildAsync(key -> {
            int resolutionLevel = (Integer)key.get(0);
            int z = (Integer)key.get(1);
            int c = (Integer)key.get(2);
            int t = (Integer)key.get(3);
            int x = (Integer)key.get(4);
            int y = (Integer)key.get(5);
            int w = (Integer)key.get(6);
            int h = (Integer)key.get(7);
            int[] shape = new int[]{1, 1, 1, h, w};
            byte[] innerBuffer = new byte[(int)this.length(shape) * this.getByteWidth()];
            this.setResolutionLevel(resolutionLevel);
            return this.getTileDirect(z, c, t, x, y, w, h, innerBuffer);
        });
    }

    public int getPixelsType() {
        DataType dataType = this.array.getDataType();
        switch (dataType) {
            case u1: {
                return 1;
            }
            case i1: {
                return 0;
            }
            case u2: {
                return 3;
            }
            case i2: {
                return 2;
            }
            case u4: {
                return 5;
            }
            case i4: {
                return 4;
            }
            case f4: {
                return 6;
            }
            case f8: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Data type " + dataType + " not supported");
    }

    private long length(int[] shape) {
        return IntStream.of(shape).mapToLong(a -> a).reduce(1L, Math::multiplyExact);
    }

    private void read(byte[] buffer, int[] shape, int[] offset) throws IOException {
        this.checkReadSize(new int[]{shape[this.axesOrder.get((Object)Axis.X)], shape[this.axesOrder.get((Object)Axis.Y)]});
        int planes = 1;
        int originalZIndex = 1;
        if (this.axesOrder.containsKey((Object)Axis.Z)) {
            originalZIndex = offset[this.axesOrder.get((Object)Axis.Z)];
        }
        if (this.getSizeZ() != this.getTrueSizeZ()) {
            offset[this.axesOrder.get((Object)((Object)Axis.Z)).intValue()] = this.zIndexMap.get(originalZIndex);
            planes = shape[this.axesOrder.get((Object)Axis.Z)];
            shape[this.axesOrder.get((Object)((Object)Axis.Z)).intValue()] = 1;
        }
        try {
            ByteBuffer asByteBuffer = ByteBuffer.wrap(buffer);
            DataType dataType = this.array.getDataType();
            block11: for (int z = 0; z < planes; ++z) {
                if (this.axesOrder.containsKey((Object)Axis.Z)) {
                    offset[this.axesOrder.get((Object)((Object)Axis.Z)).intValue()] = this.zIndexMap.get(originalZIndex + z);
                }
                switch (dataType) {
                    case u1: 
                    case i1: {
                        this.array.read((Object)buffer, shape, offset);
                        continue block11;
                    }
                    case u2: 
                    case i2: {
                        Object[] data = (short[])this.array.read(shape, offset);
                        asByteBuffer.asShortBuffer().put((short[])data);
                        continue block11;
                    }
                    case u4: 
                    case i4: {
                        Object[] data = (int[])this.array.read(shape, offset);
                        asByteBuffer.asIntBuffer().put((int[])data);
                        continue block11;
                    }
                    case i8: {
                        Object[] data = (long[])this.array.read(shape, offset);
                        asByteBuffer.asLongBuffer().put((long[])data);
                        continue block11;
                    }
                    case f4: {
                        Object[] data = (float[])this.array.read(shape, offset);
                        asByteBuffer.asFloatBuffer().put((float[])data);
                        continue block11;
                    }
                    case f8: {
                        Object[] data = (double[])this.array.read(shape, offset);
                        asByteBuffer.asDoubleBuffer().put((double[])data);
                        continue block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Data type " + dataType + " not supported");
                    }
                }
            }
        }
        catch (InvalidRangeException e) {
            log.error("Error reading Zarr data", (Throwable)e);
            throw new IOException(e);
        }
        catch (Exception e) {
            log.error("Error reading Zarr data", (Throwable)e);
            throw e;
        }
    }

    private PixelData toPixelData(byte[] buffer) {
        if (buffer == null) {
            return null;
        }
        PixelData d = new PixelData(FormatTools.getPixelTypeString((int)this.getPixelsType()), ByteBuffer.wrap(buffer));
        d.setOrder(ByteOrder.BIG_ENDIAN);
        return d;
    }

    public int[][] getChunks() throws IOException {
        List<Map<String, String>> datasets = this.getDatasets();
        ArrayList<int[]> chunks = new ArrayList<int[]>();
        for (Map<String, String> dataset : datasets) {
            ZarrArray resolutionArray = ZarrArray.open((Path)this.root.resolve(dataset.get("path")));
            int[] shape = resolutionArray.getChunks();
            chunks.add(shape);
        }
        return (int[][])chunks.toArray((T[])new int[chunks.size()][]);
    }

    public List<Map<String, String>> getDatasets() {
        return (List)this.getMultiscalesMetadata().get(0).get("datasets");
    }

    public Map<Axis, Integer> getAxesOrder() {
        HashMap<Axis, Integer> order = new HashMap<Axis, Integer>();
        List axesData = (List)this.getMultiscalesMetadata().get(0).get("axes");
        if (axesData == null) {
            log.warn("No axes metadata found, defaulting to standard axes TCZYX");
            order.put(Axis.T, 0);
            order.put(Axis.C, 1);
            order.put(Axis.Z, 2);
            order.put(Axis.Y, 3);
            order.put(Axis.X, 4);
        } else {
            for (int i = 0; i < axesData.size(); ++i) {
                Map axis = (Map)axesData.get(i);
                String name = axis.get("name").toString().toUpperCase();
                try {
                    order.put(Axis.valueOf(name), i);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid axis name (only T,C,Z,Y,X are supported): " + name);
                }
            }
        }
        if (!order.containsKey((Object)Axis.X) || !order.containsKey((Object)Axis.Y)) {
            throw new IllegalArgumentException("Missing X or Y axis!");
        }
        return order;
    }

    public List<Map<String, Object>> getMultiscalesMetadata() {
        return (List)this.rootGroupAttributes.get("multiscales");
    }

    public Map<String, Object> getRootGroupAttributes() {
        return this.rootGroupAttributes;
    }

    public void close() throws IOException {
    }

    public void checkBounds(Integer x, Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        if (x != null && (x > this.getSizeX() - 1 || x < 0)) {
            throw new DimensionsOutOfBoundsException("X '" + x + "' greater than sizeX '" + this.getSizeX() + "' or < '0'.");
        }
        if (y != null && (y > this.getSizeY() - 1 || y < 0)) {
            throw new DimensionsOutOfBoundsException("Y '" + y + "' greater than sizeY '" + this.getSizeY() + "' or < '0'.");
        }
        if (z != null && (z > this.getSizeZ() - 1 || z < 0)) {
            throw new DimensionsOutOfBoundsException("Z '" + z + "' greater than sizeZ '" + this.getSizeZ() + "' or < '0'.");
        }
        if (c != null && (c > this.getSizeC() - 1 || c < 0)) {
            throw new DimensionsOutOfBoundsException("C '" + c + "' greater than sizeC '" + this.getSizeC() + "' or < '0'.");
        }
        if (t != null && (t > this.getSizeT() - 1 || t < 0)) {
            throw new DimensionsOutOfBoundsException("T '" + t + "' greater than sizeT '" + this.getSizeT() + "' or < '0'.");
        }
    }

    public void checkReadSize(int[] shape) {
        long maxLength;
        long length = this.length(shape);
        if (length > (maxLength = (long)(this.maxPlaneWidth * this.maxPlaneHeight))) {
            throw new IllegalArgumentException(String.format("Requested shape %s > max plane size %d * %d", Arrays.toString(shape), this.maxPlaneWidth, this.maxPlaneHeight));
        }
    }

    public Long getPlaneSize() {
        return (long)this.getRowSize().intValue() * (long)this.getSizeY();
    }

    public Integer getRowSize() {
        return this.getSizeX() * this.getByteWidth();
    }

    public Integer getColSize() {
        return this.getSizeY() * this.getByteWidth();
    }

    public Long getStackSize() {
        return this.getPlaneSize() * (long)this.getSizeZ();
    }

    public Long getTimepointSize() {
        return this.getStackSize() * (long)this.getSizeC();
    }

    public Long getTotalSize() {
        return this.getTimepointSize() * (long)this.getSizeT();
    }

    public Long getHypercubeSize(List<Integer> offset, List<Integer> size, List<Integer> step) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not support Hypercube access");
    }

    public Long getRowOffset(Integer y, Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not provide row offsets");
    }

    public Long getPlaneOffset(Integer z, Integer c, Integer t) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not provide plane offsets");
    }

    public Long getStackOffset(Integer c, Integer t) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not provide stack offsets");
    }

    public Long getTimepointOffset(Integer t) throws DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not provide timepoint offsets");
    }

    public PixelData getHypercube(List<Integer> offset, List<Integer> size, List<Integer> step) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not support Hypercube access");
    }

    public byte[] getHypercubeDirect(List<Integer> offset, List<Integer> size, List<Integer> step, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not support Hypercube access");
    }

    public byte[] getPlaneRegionDirect(Integer z, Integer c, Integer t, Integer count, Integer offset, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not support plane region access");
    }

    public PixelData getTile(Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h) throws IOException {
        this.checkBounds(x, y, z, c, t);
        this.checkBounds(x + w - 1, y + h - 1, z, c, t);
        this.checkReadSize(new int[]{w, h});
        ArrayList<List<Integer>> keys = new ArrayList<List<Integer>>();
        List<Integer> key = null;
        List<Integer> channels = Arrays.asList(c);
        if (this.getSizeC() == 3 && this.isRemote) {
            channels = Arrays.asList(0, 1, 2);
        }
        for (Integer channel : channels) {
            List<Integer> v = Arrays.asList(this.getResolutionLevel(), z, channel, t, x, y, w, h);
            keys.add(v);
            if (channel != c) continue;
            key = v;
        }
        if (this.tileCache.getIfPresent(key) == null) {
            this.tileCache.synchronous().invalidateAll();
        }
        return this.toPixelData((byte[])((Map)this.tileCache.getAll(keys).join()).get(key));
    }

    public byte[] getTileDirect(Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h, byte[] buffer) throws IOException {
        try {
            this.checkBounds(x, y, z, c, t);
            this.checkBounds(x + w - 1, y + h - 1, z, c, t);
            int[] shape = new int[this.axesOrder.size()];
            int[] offset = new int[this.axesOrder.size()];
            if (this.axesOrder.containsKey((Object)Axis.T)) {
                shape[this.axesOrder.get((Object)((Object)Axis.T)).intValue()] = 1;
                offset[this.axesOrder.get((Object)((Object)Axis.T)).intValue()] = t;
            }
            if (this.axesOrder.containsKey((Object)Axis.C)) {
                shape[this.axesOrder.get((Object)((Object)Axis.C)).intValue()] = 1;
                offset[this.axesOrder.get((Object)((Object)Axis.C)).intValue()] = c;
            }
            if (this.axesOrder.containsKey((Object)Axis.Z)) {
                shape[this.axesOrder.get((Object)((Object)Axis.Z)).intValue()] = 1;
                offset[this.axesOrder.get((Object)((Object)Axis.Z)).intValue()] = z;
            }
            shape[this.axesOrder.get((Object)((Object)Axis.Y)).intValue()] = h;
            shape[this.axesOrder.get((Object)((Object)Axis.X)).intValue()] = w;
            offset[this.axesOrder.get((Object)((Object)Axis.Y)).intValue()] = y;
            offset[this.axesOrder.get((Object)((Object)Axis.X)).intValue()] = x;
            this.read(buffer, shape, offset);
            return buffer;
        }
        catch (Exception e) {
            log.error("Error while retrieving pixel data", (Throwable)e);
            return null;
        }
    }

    public PixelData getRegion(Integer size, Long offset) throws IOException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not support region access");
    }

    public byte[] getRegionDirect(Integer size, Long offset, byte[] buffer) throws IOException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not support region access");
    }

    public PixelData getRow(Integer y, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        return this.toPixelData(this.getRowDirect(y, z, c, t, new byte[this.getRowSize().intValue()]));
    }

    public PixelData getCol(Integer x, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        return this.toPixelData(this.getColDirect(x, z, c, t, new byte[this.getColSize().intValue()]));
    }

    public byte[] getRowDirect(Integer y, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        int x = 0;
        int w = this.getSizeX();
        int h = 1;
        return this.getTileDirect(z, c, t, x, y, w, h, buffer);
    }

    public byte[] getColDirect(Integer x, Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        int y = 0;
        int w = 1;
        int h = this.getSizeY();
        return this.getTileDirect(z, c, t, x, y, w, h, buffer);
    }

    public PixelData getPlane(Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        int planeSize = RomioPixelBuffer.safeLongToInteger((Long)this.getPlaneSize());
        return this.toPixelData(this.getPlaneDirect(z, c, t, new byte[planeSize]));
    }

    public PixelData getPlaneRegion(Integer x, Integer y, Integer width, Integer height, Integer z, Integer c, Integer t, Integer stride) throws IOException, DimensionsOutOfBoundsException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not support plane region access");
    }

    public byte[] getPlaneDirect(Integer z, Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        int y = 0;
        int x = 0;
        int w = this.getSizeX();
        int h = this.getSizeY();
        return this.getTileDirect(z, c, t, x, y, w, h, buffer);
    }

    public PixelData getStack(Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException {
        int stackSize = RomioPixelBuffer.safeLongToInteger((Long)this.getStackSize());
        byte[] buffer = new byte[stackSize];
        return this.toPixelData(this.getStackDirect(c, t, buffer));
    }

    public byte[] getStackDirect(Integer c, Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        int x = 0;
        int y = 0;
        int z = 0;
        int w = this.getSizeX();
        int h = this.getSizeY();
        this.checkBounds(x, y, z, c, t);
        this.checkBounds(x + w - 1, y + h - 1, z, c, t);
        int[] shape = new int[this.axesOrder.size()];
        int[] offset = new int[this.axesOrder.size()];
        if (this.axesOrder.containsKey((Object)Axis.T)) {
            shape[this.axesOrder.get((Object)((Object)Axis.T)).intValue()] = 1;
            offset[this.axesOrder.get((Object)((Object)Axis.T)).intValue()] = t;
        }
        if (this.axesOrder.containsKey((Object)Axis.C)) {
            shape[this.axesOrder.get((Object)((Object)Axis.C)).intValue()] = 1;
            offset[this.axesOrder.get((Object)((Object)Axis.C)).intValue()] = c;
        }
        if (this.axesOrder.containsKey((Object)Axis.Z)) {
            shape[this.axesOrder.get((Object)((Object)Axis.Z)).intValue()] = this.getSizeZ();
            offset[this.axesOrder.get((Object)((Object)Axis.Z)).intValue()] = z;
        }
        shape[this.axesOrder.get((Object)((Object)Axis.Y)).intValue()] = h;
        shape[this.axesOrder.get((Object)((Object)Axis.X)).intValue()] = w;
        offset[this.axesOrder.get((Object)((Object)Axis.Y)).intValue()] = y;
        offset[this.axesOrder.get((Object)((Object)Axis.X)).intValue()] = x;
        this.read(buffer, shape, offset);
        return buffer;
    }

    public PixelData getTimepoint(Integer t) throws IOException, DimensionsOutOfBoundsException {
        int timepointSize = RomioPixelBuffer.safeLongToInteger((Long)this.getTimepointSize());
        byte[] buffer = new byte[timepointSize];
        return this.toPixelData(this.getTimepointDirect(t, buffer));
    }

    public byte[] getTimepointDirect(Integer t, byte[] buffer) throws IOException, DimensionsOutOfBoundsException {
        int x = 0;
        int y = 0;
        int z = 0;
        int c = 0;
        int w = this.getSizeX();
        int h = this.getSizeY();
        this.checkBounds(x, y, z, c, t);
        this.checkBounds(x + w - 1, y + h - 1, z, c, t);
        int[] shape = new int[this.axesOrder.size()];
        int[] offset = new int[this.axesOrder.size()];
        if (this.axesOrder.containsKey((Object)Axis.T)) {
            shape[this.axesOrder.get((Object)((Object)Axis.T)).intValue()] = 1;
            offset[this.axesOrder.get((Object)((Object)Axis.T)).intValue()] = t;
        }
        if (this.axesOrder.containsKey((Object)Axis.C)) {
            shape[this.axesOrder.get((Object)((Object)Axis.C)).intValue()] = this.getSizeC();
            offset[this.axesOrder.get((Object)((Object)Axis.C)).intValue()] = c;
        }
        if (this.axesOrder.containsKey((Object)Axis.Z)) {
            shape[this.axesOrder.get((Object)((Object)Axis.Z)).intValue()] = this.getSizeZ();
            offset[this.axesOrder.get((Object)((Object)Axis.Z)).intValue()] = z;
        }
        shape[this.axesOrder.get((Object)((Object)Axis.Y)).intValue()] = h;
        shape[this.axesOrder.get((Object)((Object)Axis.X)).intValue()] = w;
        offset[this.axesOrder.get((Object)((Object)Axis.Y)).intValue()] = y;
        offset[this.axesOrder.get((Object)((Object)Axis.X)).intValue()] = x;
        this.read(buffer, shape, offset);
        return buffer;
    }

    public void setTile(byte[] buffer, Integer z, Integer c, Integer t, Integer x, Integer y, Integer w, Integer h) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to Zarr");
    }

    public void setRegion(Integer size, Long offset, byte[] buffer) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to Zarr");
    }

    public void setRegion(Integer size, Long offset, ByteBuffer buffer) throws IOException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to Zarr");
    }

    public void setRow(ByteBuffer buffer, Integer y, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to Zarr");
    }

    public void setPlane(ByteBuffer buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to Zarr");
    }

    public void setPlane(byte[] buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to Zarr");
    }

    public void setStack(ByteBuffer buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to Zarr");
    }

    public void setStack(byte[] buffer, Integer z, Integer c, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to Zarr");
    }

    public void setTimepoint(ByteBuffer buffer, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to Zarr");
    }

    public void setTimepoint(byte[] buffer, Integer t) throws IOException, DimensionsOutOfBoundsException, BufferOverflowException {
        throw new UnsupportedOperationException("Cannot write to Zarr");
    }

    public byte[] calculateMessageDigest() throws IOException {
        throw new UnsupportedOperationException("Zarr pixel buffer does not support message digest calculation");
    }

    public int getByteWidth() {
        return FormatTools.getBytesPerPixel((int)this.getPixelsType());
    }

    public boolean isSigned() {
        return FormatTools.isSigned((int)this.getPixelsType());
    }

    public boolean isFloat() {
        return FormatTools.isFloatingPoint((int)this.getPixelsType());
    }

    public String getPath() {
        return this.root.toString();
    }

    public long getId() {
        return 0L;
    }

    public int getSizeX() {
        return this.array.getShape()[this.axesOrder.get((Object)Axis.X)];
    }

    public int getSizeY() {
        return this.array.getShape()[this.axesOrder.get((Object)Axis.Y)];
    }

    public int getSizeZ() {
        if (this.axesOrder.containsKey((Object)Axis.Z)) {
            return this.zIndexMap.size();
        }
        return 1;
    }

    private int getTrueSizeZ() {
        if (this.axesOrder.containsKey((Object)Axis.Z)) {
            return this.array.getShape()[this.axesOrder.get((Object)Axis.Z)];
        }
        return 1;
    }

    public int getSizeC() {
        if (this.axesOrder.containsKey((Object)Axis.C)) {
            return this.array.getShape()[this.axesOrder.get((Object)Axis.C)];
        }
        return 1;
    }

    public int getSizeT() {
        if (this.axesOrder.containsKey((Object)Axis.T)) {
            return this.array.getShape()[this.axesOrder.get((Object)Axis.T)];
        }
        return 1;
    }

    public int getResolutionLevels() {
        return this.getDatasets().size();
    }

    public int getResolutionLevel() {
        return Math.abs(this.resolutionLevel - (this.resolutionLevels - 1));
    }

    public void setResolutionLevel(int resolutionLevel) {
        if (resolutionLevel >= this.resolutionLevels) {
            throw new IllegalArgumentException("Resolution level out of bounds!");
        }
        this.resolutionLevel = Math.abs(resolutionLevel - (this.resolutionLevels - 1));
        if (this.resolutionLevel < 0) {
            throw new IllegalArgumentException("This Zarr file has no pixel data");
        }
        if (this.zIndexMap == null) {
            this.zIndexMap = new HashMap<Integer, Integer>();
        } else {
            this.zIndexMap.clear();
        }
        try {
            this.array = (ZarrArray)this.zarrArrayCache.get((Object)this.root.resolve(Integer.toString(this.resolutionLevel))).get();
            ZarrArray fullResolutionArray = (ZarrArray)this.zarrArrayCache.get((Object)this.root.resolve("0")).get();
            if (this.axesOrder.containsKey((Object)Axis.Z)) {
                int fullResZ = fullResolutionArray.getShape()[this.axesOrder.get((Object)Axis.Z)];
                int arrayZ = this.array.getShape()[this.axesOrder.get((Object)Axis.Z)];
                for (int z = 0; z < fullResZ; ++z) {
                    this.zIndexMap.put(z, Math.round(z * arrayZ / fullResZ));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Dimension getTileSize() {
        try {
            int[] chunks = this.getChunks()[this.resolutionLevel];
            return new Dimension(chunks[this.axesOrder.get((Object)Axis.X)], chunks[this.axesOrder.get((Object)Axis.Y)]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<List<Integer>> getResolutionDescriptions() {
        try {
            int resolutionLevels = this.getResolutionLevels();
            ArrayList<List<Integer>> resolutionDescriptions = new ArrayList<List<Integer>>();
            int sizeX = this.pixels.getSizeX();
            int sizeY = this.pixels.getSizeY();
            for (int i = 0; i < resolutionLevels; ++i) {
                double scale = Math.pow(2.0, i);
                resolutionDescriptions.add(Arrays.asList((int)((double)sizeX / scale), (int)((double)sizeY / scale)));
            }
            return resolutionDescriptions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Axis {
        X,
        Y,
        Z,
        C,
        T;

    }
}

