/*
 * Decompiled with CFR 0.152.
 */
package com.glencoesoftware.omero.zarr;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.EC2ContainerCredentialsProviderWrapper;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.util.AwsHostNameUtils;
import com.upplication.s3fs.AmazonS3ClientFactory;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmeroAmazonS3ClientFactory
extends AmazonS3ClientFactory {
    private static final Logger log = LoggerFactory.getLogger(OmeroAmazonS3ClientFactory.class);
    private static final Map<String, AmazonS3> bucketClientMap = new HashMap<String, AmazonS3>();

    protected AWSCredentialsProvider getCredentialsProvider(Properties props) {
        if (System.getenv("AWS_ACCESS_KEY_ID") != null || System.getenv("AWS_SECRET_ACCESS_KEY") != null || System.getenv("AWS_SESSION_TOKEN") != null || System.getProperty("aws.accessKeyId") != null || System.getProperty("aws.secretAccessKey") != null) {
            throw new RuntimeException("AWS credentials supplied by environment variables or Java system properties are not supported. Please use either named profiles or instance profile credentials.");
        }
        boolean anonymous = Boolean.parseBoolean((String)props.get("s3fs_anonymous"));
        if (anonymous) {
            log.debug("Using anonymous credentials");
            return new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials());
        }
        String profileName = (String)props.get("s3fs_credential_profile_name");
        return new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new ProfileCredentialsProvider(profileName), new EC2ContainerCredentialsProviderWrapper()});
    }

    private String getBucketFromUri(URI uri) {
        String path = uri.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return path.substring(0, path.indexOf("/"));
    }

    private String getRegionFromUri(URI uri) {
        String region = AwsHostNameUtils.parseRegion((String)uri.getHost(), null);
        if (region != null) {
            return region;
        }
        return Regions.DEFAULT_REGION.getName();
    }

    public String getEndPointFromUri(URI uri) {
        return "https://" + uri.getHost();
    }

    public synchronized AmazonS3 getAmazonS3(URI uri, Properties props) {
        String bucket = this.getBucketFromUri(uri);
        if (bucketClientMap.containsKey(bucket)) {
            log.info("Found bucket " + bucket);
            return bucketClientMap.get(bucket);
        }
        log.info("Creating client for bucket " + bucket);
        AmazonS3 client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(this.getCredentialsProvider(props))).withClientConfiguration(this.getClientConfiguration(props))).withMetricsCollector(this.getRequestMetricsCollector(props))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getEndPointFromUri(uri), this.getRegionFromUri(uri)))).build();
        bucketClientMap.put(bucket, client);
        return client;
    }
}

