/*
 * Decompiled with CFR 0.152.
 */
package dev.zarr.zarrjava.v3;

import com.fasterxml.jackson.databind.ObjectWriter;
import dev.zarr.zarrjava.ZarrException;
import dev.zarr.zarrjava.core.Attributes;
import dev.zarr.zarrjava.core.codec.CodecPipeline;
import dev.zarr.zarrjava.store.FilesystemStore;
import dev.zarr.zarrjava.store.StoreHandle;
import dev.zarr.zarrjava.utils.Utils;
import dev.zarr.zarrjava.v3.ArrayMetadata;
import dev.zarr.zarrjava.v3.ArrayMetadataBuilder;
import dev.zarr.zarrjava.v3.Node;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class Array
extends dev.zarr.zarrjava.core.Array
implements Node {
    private final ArrayMetadata metadata;

    @Override
    public ArrayMetadata metadata() {
        return this.metadata;
    }

    protected Array(StoreHandle storeHandle, ArrayMetadata arrayMetadata) throws ZarrException {
        super(storeHandle);
        this.metadata = arrayMetadata;
        this.codecPipeline = new CodecPipeline(arrayMetadata.codecs, arrayMetadata.coreArrayMetadata);
    }

    public static Array open(StoreHandle storeHandle) throws IOException, ZarrException {
        return new Array(storeHandle, (ArrayMetadata)Node.makeObjectMapper().readValue(Utils.toArray(storeHandle.resolve("zarr.json").readNonNull()), ArrayMetadata.class));
    }

    public static Array open(Path path) throws IOException, ZarrException {
        return Array.open(new FilesystemStore(path).resolve(new String[0]));
    }

    public static Array open(String path) throws IOException, ZarrException {
        return Array.open(Paths.get(path, new String[0]));
    }

    public static Array create(Path path, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        return Array.create(new FilesystemStore(path).resolve(new String[0]), arrayMetadata);
    }

    public static Array create(String path, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        return Array.create(Paths.get(path, new String[0]), arrayMetadata);
    }

    public static Array create(StoreHandle storeHandle, ArrayMetadata arrayMetadata) throws IOException, ZarrException {
        return Array.create(storeHandle, arrayMetadata, false);
    }

    public static Array create(StoreHandle storeHandle, ArrayMetadata arrayMetadata, boolean existsOk) throws IOException, ZarrException {
        StoreHandle metadataHandle = storeHandle.resolve("zarr.json");
        if (!existsOk && metadataHandle.exists()) {
            throw new RuntimeException("Trying to create a new array in " + storeHandle + ". But " + metadataHandle + " already exists.");
        }
        ObjectWriter objectWriter = Node.makeObjectWriter();
        ByteBuffer metadataBytes = ByteBuffer.wrap(objectWriter.writeValueAsBytes((Object)arrayMetadata));
        metadataHandle.set(metadataBytes);
        return new Array(storeHandle, arrayMetadata);
    }

    public static Array create(StoreHandle storeHandle, Function<ArrayMetadataBuilder, ArrayMetadataBuilder> arrayMetadataBuilderMapper, boolean existsOk) throws IOException, ZarrException {
        return Array.create(storeHandle, arrayMetadataBuilderMapper.apply(new ArrayMetadataBuilder()).build(), existsOk);
    }

    public static Array create(Path path, Function<ArrayMetadataBuilder, ArrayMetadataBuilder> arrayMetadataBuilderMapper, boolean existsOk) throws IOException, ZarrException {
        return Array.create(new FilesystemStore(path).resolve(new String[0]), arrayMetadataBuilderMapper, existsOk);
    }

    public static Array create(String path, Function<ArrayMetadataBuilder, ArrayMetadataBuilder> arrayMetadataBuilderMapper, boolean existsOk) throws IOException, ZarrException {
        return Array.create(Paths.get(path, new String[0]), arrayMetadataBuilderMapper, existsOk);
    }

    @Nonnull
    public static ArrayMetadataBuilder metadataBuilder() {
        return new ArrayMetadataBuilder();
    }

    @Nonnull
    public static ArrayMetadataBuilder metadataBuilder(ArrayMetadata existingMetadata) {
        return ArrayMetadataBuilder.fromArrayMetadata(existingMetadata);
    }

    private Array writeMetadata(ArrayMetadata newArrayMetadata) throws ZarrException, IOException {
        return Array.create(this.storeHandle, newArrayMetadata, true);
    }

    public Array resize(long[] newShape) throws ZarrException, IOException {
        if (newShape.length != this.metadata.ndim()) {
            throw new IllegalArgumentException("'newShape' needs to have rank '" + this.metadata.ndim() + "'.");
        }
        ArrayMetadata newArrayMetadata = ArrayMetadataBuilder.fromArrayMetadata(this.metadata).withShape(newShape).build();
        return this.writeMetadata(newArrayMetadata);
    }

    public Array setAttributes(Attributes newAttributes) throws ZarrException, IOException {
        ArrayMetadata newArrayMetadata = ArrayMetadataBuilder.fromArrayMetadata(this.metadata, false).withAttributes(newAttributes).build();
        return this.writeMetadata(newArrayMetadata);
    }

    public Array updateAttributes(Function<Attributes, Attributes> attributeMapper) throws ZarrException, IOException {
        return this.setAttributes(attributeMapper.apply(this.metadata.attributes));
    }

    public String toString() {
        return String.format("<v3.Array {%s} (%s) %s>", this.storeHandle, Arrays.stream(this.metadata.shape).mapToObj(Long::toString).collect(Collectors.joining(", ")), this.metadata.dataType);
    }
}

