/*
 * Decompiled with CFR 0.152.
 */
package com.glencoesoftware.omero.zarr;

import com.bc.zarr.ZarrArray;
import com.bc.zarr.ZarrGroup;
import com.bc.zarr.storage.OmeroFileSystemStore;
import com.bc.zarr.storage.Store;
import com.github.benmanes.caffeine.cache.AsyncLoadingCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.glencoesoftware.omero.zarr.ZarrPixelBuffer;
import com.google.common.base.Splitter;
import com.upplication.s3fs.OmeroS3FilesystemProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ome.api.IQuery;
import ome.conditions.LockTimeout;
import ome.io.nio.BackOff;
import ome.io.nio.FilePathResolver;
import ome.io.nio.PixelBuffer;
import ome.io.nio.PixelsService;
import ome.io.nio.TileSizes;
import ome.model.IObject;
import ome.model.core.Image;
import ome.model.core.Pixels;
import ome.model.meta.ExternalInfo;
import ome.model.roi.Mask;
import org.perf4j.slf4j.Slf4JStopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZarrPixelsService
extends PixelsService {
    private static final Logger log = LoggerFactory.getLogger(ZarrPixelsService.class);
    public static final String NGFF_ENTITY_TYPE = "com.glencoesoftware.ngff:multiscales";
    public static final long NGFF_ENTITY_ID = 3L;
    protected final Integer maxPlaneWidth;
    protected final Integer maxPlaneHeight;
    private final long zarrCacheSize;
    private final IQuery iQuery;
    private final AsyncLoadingCache<Path, Map<String, Object>> zarrMetadataCache;
    private final AsyncLoadingCache<Path, ZarrArray> zarrArrayCache;

    public ZarrPixelsService(String path, boolean isReadOnlyRepo, File memoizerDirectory, long memoizerWait, FilePathResolver resolver, BackOff backOff, TileSizes sizes, IQuery iQuery, long zarrCacheSize, int maxPlaneWidth, int maxPlaneHeight) {
        super(path, isReadOnlyRepo, memoizerDirectory, memoizerWait, resolver, backOff, sizes, iQuery);
        this.zarrCacheSize = zarrCacheSize;
        log.info("Zarr metadata and array cache size: {}", (Object)zarrCacheSize);
        this.maxPlaneWidth = maxPlaneWidth;
        this.maxPlaneHeight = maxPlaneHeight;
        this.iQuery = iQuery;
        this.zarrMetadataCache = Caffeine.newBuilder().maximumSize(this.zarrCacheSize).buildAsync(ZarrPixelsService::getZarrMetadata);
        this.zarrArrayCache = Caffeine.newBuilder().maximumSize(this.zarrCacheSize).buildAsync(ZarrPixelsService::getZarrArray);
    }

    public static Map<String, Object> getZarrMetadata(Path path) throws IOException {
        return ZarrGroup.open((Store)new OmeroFileSystemStore(path)).getAttributes();
    }

    public static ZarrArray getZarrArray(Path path) throws IOException {
        return ZarrArray.open((Store)new OmeroFileSystemStore(path));
    }

    public static Path asPath(String ngffDir) throws IOException {
        if (ngffDir.isEmpty()) {
            return null;
        }
        try {
            URI uri = new URI(ngffDir);
            if ("s3".equals(uri.getScheme())) {
                if (uri.getUserInfo() != null && !uri.getUserInfo().isEmpty()) {
                    throw new RuntimeException("Found unsupported user information in S3 URI. If you are trying to pass S3 credentials, use either named profiles or instance credentials.");
                }
                String query = Optional.ofNullable(uri.getQuery()).orElse("");
                Map params = Splitter.on((char)'&').trimResults().omitEmptyStrings().withKeyValueSeparator('=').split((CharSequence)query);
                String uriPath = uri.getPath().substring(1);
                int first = uriPath.indexOf("/");
                String bucket = "/" + uriPath.substring(0, first);
                String rest = uriPath.substring(first + 1);
                HashMap<String, String> env = new HashMap<String, String>();
                String profile = (String)params.get("profile");
                if (profile != null) {
                    env.put("s3fs_credential_profile_name", profile);
                }
                String anonymous = Optional.ofNullable((String)params.get("anonymous")).orElse("false");
                env.put("s3fs_anonymous", anonymous);
                OmeroS3FilesystemProvider fsp = new OmeroS3FilesystemProvider();
                FileSystem fs = fsp.newFileSystem(uri, env);
                return fs.getPath(bucket, rest);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return Paths.get(ngffDir, new String[0]);
    }

    public String getUri(IObject object) {
        return this.getUri(object, NGFF_ENTITY_TYPE, 3L);
    }

    public String getUri(IObject object, String targetEntityType, Long targetEntityId) {
        ExternalInfo externalInfo = object.getDetails().getExternalInfo();
        if (externalInfo == null) {
            log.debug("{}:{} missing ExternalInfo", (Object)object.getClass().getSimpleName(), (Object)object.getId());
            return null;
        }
        String entityType = externalInfo.getEntityType();
        if (entityType == null) {
            log.debug("{}:{} missing ExternalInfo entityType", (Object)object.getClass().getSimpleName(), (Object)object.getId());
            return null;
        }
        if (!entityType.equals(targetEntityType)) {
            log.debug("{}:{} unsupported ExternalInfo entityType {}", new Object[]{object.getClass().getSimpleName(), object.getId(), entityType});
            return null;
        }
        Long entityId = externalInfo.getEntityId();
        if (entityType == null) {
            log.debug("{}:{} missing ExternalInfo entityId", (Object)object.getClass().getSimpleName(), (Object)object.getId());
            return null;
        }
        if (!entityId.equals(targetEntityId)) {
            log.debug("{}:{} unsupported ExternalInfo entityId {}", new Object[]{object.getClass().getSimpleName(), object.getId(), entityId});
            return null;
        }
        String uri = externalInfo.getLsid();
        if (uri == null) {
            log.debug("{}:{} missing LSID", (Object)object.getClass().getSimpleName(), (Object)object.getId());
            return null;
        }
        return uri;
    }

    protected Image getImage(Pixels pixels) {
        if (pixels.getImage().isLoaded()) {
            return pixels.getImage();
        }
        return (Image)this.iQuery.get(Image.class, pixels.getImage().getId().longValue());
    }

    protected int getSeries(Pixels pixels) {
        if (pixels.getImage().isLoaded()) {
            return pixels.getImage().getSeries();
        }
        return super.getSeries(pixels);
    }

    public ZarrPixelBuffer getLabelImagePixelBuffer(Mask mask) throws IOException {
        Pixels pixels = new Pixels();
        pixels.setSizeX(Integer.valueOf(mask.getWidth().intValue()));
        pixels.setSizeY(Integer.valueOf(mask.getHeight().intValue()));
        pixels.setSizeC(Integer.valueOf(1));
        pixels.setSizeT(Integer.valueOf(1));
        pixels.setSizeZ(Integer.valueOf(1));
        String root = this.getUri((IObject)mask);
        if (root == null) {
            throw new IllegalArgumentException("No root for Mask:" + mask.getId());
        }
        return new ZarrPixelBuffer(pixels, ZarrPixelsService.asPath(root), this.maxPlaneWidth, this.maxPlaneHeight, this.zarrMetadataCache, this.zarrArrayCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZarrPixelBuffer createOmeNgffPixelBuffer(Pixels pixels) {
        block11: {
            Slf4JStopWatch t0 = new Slf4JStopWatch("createOmeNgffPixelBuffer()");
            try {
                Image image = this.getImage(pixels);
                String uri = this.getUri((IObject)image);
                if (uri == null) {
                    if (image.getFormat() != null && "OMEXML".equals(image.getFormat().getValue())) {
                        throw new LockTimeout("Import in progress.", 15000L, 0);
                    }
                    log.debug("No OME-NGFF root");
                    ZarrPixelBuffer zarrPixelBuffer = null;
                    return zarrPixelBuffer;
                }
                Path root = ZarrPixelsService.asPath(uri);
                log.info("OME-NGFF root is: " + uri);
                try {
                    ZarrPixelBuffer v = new ZarrPixelBuffer(pixels, root, this.maxPlaneWidth, this.maxPlaneHeight, this.zarrMetadataCache, this.zarrArrayCache);
                    log.info("Using OME-NGFF pixel buffer");
                    ZarrPixelBuffer zarrPixelBuffer = v;
                    return zarrPixelBuffer;
                }
                catch (Exception e) {
                    try {
                        log.warn("Getting OME-NGFF pixel buffer failed - attempting to get local data", (Throwable)e);
                    }
                    catch (IOException e1) {
                        log.debug("Failed to find OME-NGFF metadata for Pixels:{}", (Object)pixels.getId());
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    t0.stop();
                }
            }
            finally {
                t0.stop();
            }
        }
        return null;
    }

    public PixelBuffer getPixelBuffer(Pixels pixels, boolean write) {
        ZarrPixelBuffer pixelBuffer = this.createOmeNgffPixelBuffer(pixels);
        if (pixelBuffer != null) {
            return pixelBuffer;
        }
        return this._getPixelBuffer(pixels, write);
    }
}

